"use client"

import { Button } from "@/components/ui/button"
import { Bus, Phone, Mail, MapPin, Instagram, Menu, X } from "lucide-react"
import Image from "next/image"
import Link from "next/link"
import { useState } from "react"
import { ClientContactForm } from "@/components/contact-form"

export default function LandingPage() {
  return (
    <div className="flex min-h-screen flex-col">
      <Header />
      <main>
        <HeroSection />
        <AboutSection />
        <ServicesSection />
        <FleetSection />
        <TestimonialsSection />
        <ContactSection />
      </main>
      <Footer />
    </div>
  )
}

function Header() {
  return (
    <header className="sticky top-0 z-50 w-full border-b bg-white">
      <div className="container flex h-16 items-center justify-between">
        <div className="flex items-center gap-2">
          <Bus className="h-6 w-6 text-blue-600" />
          <span className="text-xl font-bold">Fabrício Turismo</span>
        </div>
        <nav className="hidden md:flex gap-6">
          <a href="#home" className="text-sm font-medium hover:text-blue-600 transition-colors">
            Início
          </a>
          <a href="#sobre" className="text-sm font-medium hover:text-blue-600 transition-colors">
            Sobre Nós
          </a>
          <a href="#servicos" className="text-sm font-medium hover:text-blue-600 transition-colors">
            Serviços
          </a>
          <a href="#frota" className="text-sm font-medium hover:text-blue-600 transition-colors">
            Nossa Frota
          </a>
          <a href="#depoimentos" className="text-sm font-medium hover:text-blue-600 transition-colors">
            Depoimentos
          </a>
          <a href="#contato" className="text-sm font-medium hover:text-blue-600 transition-colors">
            Contato
          </a>
        </nav>
        <MobileNav />
      </div>
    </header>
  )
}

function MobileNav() {
  const [isOpen, setIsOpen] = useState(false)

  return (
    <div className="md:hidden">
      <Button variant="ghost" size="icon" onClick={() => setIsOpen(true)}>
        <Menu className="h-6 w-6" />
        <span className="sr-only">Abrir menu</span>
      </Button>
      {isOpen && (
        <div className="fixed inset-0 z-50 bg-white">
          <div className="container flex h-16 items-center justify-between">
            <div className="flex items-center gap-2">
              <Bus className="h-6 w-6 text-blue-600" />
              <span className="text-xl font-bold">Fabrício Turismo</span>
            </div>
            <Button variant="ghost" size="icon" onClick={() => setIsOpen(false)}>
              <X className="h-6 w-6" />
              <span className="sr-only">Fechar menu</span>
            </Button>
          </div>
          <nav className="container grid gap-6 py-6">
            <a
              href="#home"
              className="text-lg font-medium hover:text-blue-600 transition-colors"
              onClick={() => setIsOpen(false)}
            >
              Início
            </a>
            <a
              href="#sobre"
              className="text-lg font-medium hover:text-blue-600 transition-colors"
              onClick={() => setIsOpen(false)}
            >
              Sobre Nós
            </a>
            <a
              href="#servicos"
              className="text-lg font-medium hover:text-blue-600 transition-colors"
              onClick={() => setIsOpen(false)}
            >
              Serviços
            </a>
            <a
              href="#frota"
              className="text-lg font-medium hover:text-blue-600 transition-colors"
              onClick={() => setIsOpen(false)}
            >
              Nossa Frota
            </a>
            <a
              href="#depoimentos"
              className="text-lg font-medium hover:text-blue-600 transition-colors"
              onClick={() => setIsOpen(false)}
            >
              Depoimentos
            </a>
            <a
              href="#contato"
              className="text-lg font-medium hover:text-blue-600 transition-colors"
              onClick={() => setIsOpen(false)}
            >
              Contato
            </a>
          </nav>
        </div>
      )}
    </div>
  )
}

function HeroSection() {
  return (
    <section id="home" className="relative">
      <div className="absolute inset-0 bg-black/60 z-10" />
      <div
        className="relative h-[600px] bg-cover bg-center"
        style={{ backgroundImage: "url('/placeholder.svg?height=600&width=1200')" }}
      >
        <div className="container relative z-20 flex h-full flex-col items-center justify-center text-center text-white">
          <h1 className="text-4xl font-bold tracking-tight sm:text-5xl md:text-6xl">
            Viagens com Conforto e Segurança
          </h1>
          <p className="mt-6 max-w-3xl text-lg">
            Oferecemos serviços de fretamento de ônibus e vans para empresas, escolas, igrejas e eventos. Conte com
            nossa experiência para uma viagem tranquila e segura.
          </p>
          <div className="mt-10 flex gap-4">
            <Button size="lg" className="bg-blue-600 hover:bg-blue-700">
              <a href="#contato">Solicitar Orçamento</a>
            </Button>
            <Button size="lg" variant="outline" className="bg-white/10 text-white hover:bg-white/20">
              <a href="#servicos">Nossos Serviços</a>
            </Button>
          </div>
        </div>
      </div>
    </section>
  )
}

function AboutSection() {
  return (
    <section id="sobre" className="py-16 md:py-24 bg-gray-50">
      <div className="container">
        <div className="flex flex-col md:flex-row gap-12 items-center">
          <div className="md:w-1/2">
            <Image
              src="/placeholder.svg?height=400&width=600"
              alt="Equipe Fabrício Turismo"
              width={600}
              height={400}
              className="rounded-lg shadow-lg"
            />
          </div>
          <div className="md:w-1/2 space-y-6">
            <div className="inline-block rounded-lg bg-blue-100 px-3 py-1 text-sm text-blue-800">Sobre Nós</div>
            <h2 className="text-3xl font-bold tracking-tight sm:text-4xl">
              Mais de 20 anos de experiência em transporte
            </h2>
            <p className="text-gray-600">
              Fundada em 2008, a Fabrício Turismo nasceu com o compromisso de oferecer serviços de transporte com
              excelência, segurança e pontualidade. Nossa missão é proporcionar a melhor experiência de viagem para
              nossos clientes, com uma frota moderna e motoristas altamente qualificados.
            </p>
            <div className="grid grid-cols-1 sm:grid-cols-2 gap-6 pt-4">
              <div className="flex flex-col gap-2">
                <h3 className="text-lg font-semibold text-blue-600">Nossa Missão</h3>
                <p className="text-gray-600">
                  Proporcionar transporte seguro e confortável, superando as expectativas dos nossos clientes.
                </p>
              </div>
              <div className="flex flex-col gap-2">
                <h3 className="text-lg font-semibold text-blue-600">Nossos Valores</h3>
                <p className="text-gray-600">
                  Segurança, pontualidade, conforto, profissionalismo e respeito ao cliente.
                </p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  )
}

function ServicesSection() {
  const services = [
    {
      title: "Eventos Corporativos",
      description: "Transporte para convenções, treinamentos, confraternizações e eventos empresariais.",
      icon: "🏢",
    },
    {
      title: "Turismo & Excursões",
      description: "Viagens turísticas, excursões e passeios para grupos e agências de turismo.",
      icon: "🏖️",
    },
    {
      title: "Eventos Escolares",
      description: "Transporte seguro para passeios escolares, formaturas e eventos educacionais.",
      icon: "🎓",
    },
    {
      title: "Eventos Religiosos",
      description: "Fretamento para retiros, congressos e encontros religiosos com total conforto.",
      icon: "⛪",
    },
    {
      title: "Transporte de Funcionários",
      description: "Serviço de fretamento contínuo para transporte de colaboradores de empresas.",
      icon: "👥",
    },
    {
      title: "Eventos Esportivos",
      description: "Transporte para competições, jogos e eventos esportivos de todos os tipos.",
      icon: "🏆",
    },
  ]

  return (
    <section id="servicos" className="py-16 md:py-24">
      <div className="container">
        <div className="text-center max-w-3xl mx-auto mb-16">
          <div className="inline-block rounded-lg bg-blue-100 px-3 py-1 text-sm text-blue-800">Nossos Serviços</div>
          <h2 className="mt-3 text-3xl font-bold tracking-tight sm:text-4xl">
            Soluções de transporte para todas as necessidades
          </h2>
          <p className="mt-4 text-gray-600">
            Oferecemos uma ampla gama de serviços de fretamento para atender às mais diversas necessidades de
            transporte, sempre com conforto, segurança e pontualidade.
          </p>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
          {services.map((service, index) => (
            <div
              key={index}
              className="bg-white p-6 rounded-lg shadow-md border border-gray-100 hover:shadow-lg transition-shadow"
            >
              <div className="text-3xl mb-4">{service.icon}</div>
              <h3 className="text-xl font-semibold mb-3 text-blue-600">{service.title}</h3>
              <p className="text-gray-600">{service.description}</p>
            </div>
          ))}
        </div>
      </div>
    </section>
  )
}

function FleetSection() {
  const vehicles = [
    {
      type: "Ônibus Executivo",
      image: "/placeholder.svg?height=300&width=500",
      capacity: "46 passageiros",
      features: [
        "Ar-condicionado",
        "Poltronas reclináveis",
        "TV e DVD",
        "Sistema de som",
        "Wi-Fi",
        "Banheiro a bordo",
        "Frigobar",
      ],
    },
    {
      type: "Micro-ônibus",
      image: "/placeholder.svg?height=300&width=500",
      capacity: "28 passageiros",
      features: [
        "Ar-condicionado",
        "Poltronas reclináveis",
        "TV e DVD",
        "Sistema de som",
        "Wi-Fi",
        "Porta-malas amplo",
      ],
    },
    {
      type: "Van Executiva",
      image: "/placeholder.svg?height=300&width=500",
      capacity: "15 passageiros",
      features: [
        "Ar-condicionado",
        "Poltronas reclináveis",
        "TV e DVD",
        "Sistema de som",
        "Wi-Fi",
        "Porta-malas espaçoso",
      ],
    },
  ]

  return (
    <section id="frota" className="py-16 md:py-24 bg-gray-50">
      <div className="container">
        <div className="text-center max-w-3xl mx-auto mb-16">
          <div className="inline-block rounded-lg bg-blue-100 px-3 py-1 text-sm text-blue-800">Nossa Frota</div>
          <h2 className="mt-3 text-3xl font-bold tracking-tight sm:text-4xl">Veículos modernos e confortáveis</h2>
          <p className="mt-4 text-gray-600">
            Contamos com uma frota diversificada e moderna para atender a todos os tipos de necessidades, sempre
            priorizando o conforto e a segurança dos nossos passageiros.
          </p>
        </div>

        <div className="grid grid-cols-1 lg:grid-cols-3 gap-8">
          {vehicles.map((vehicle, index) => (
            <div key={index} className="bg-white rounded-lg shadow-md overflow-hidden">
              <div className="h-64 overflow-hidden">
                <Image
                  src={vehicle.image || "/placeholder.svg"}
                  alt={vehicle.type}
                  width={500}
                  height={300}
                  className="w-full h-full object-cover transition-transform hover:scale-105"
                />
              </div>
              <div className="p-6">
                <h3 className="text-xl font-semibold mb-2 text-blue-600">{vehicle.type}</h3>
                <p className="text-gray-600 mb-4">Capacidade: {vehicle.capacity}</p>
                <h4 className="font-medium mb-2">Características:</h4>
                <ul className="text-gray-600 space-y-1">
                  {vehicle.features.map((feature, i) => (
                    <li key={i} className="flex items-center gap-2">
                      <div className="w-1.5 h-1.5 rounded-full bg-blue-600" />
                      {feature}
                    </li>
                  ))}
                </ul>
              </div>
            </div>
          ))}
        </div>
      </div>
    </section>
  )
}

function TestimonialsSection() {
  const testimonials = [
    {
      name: "Maria Silva",
      company: "Escola Municipal São José",
      text: "Contratamos a Fabrício Turismo para nossa excursão escolar anual e ficamos extremamente satisfeitos. Os ônibus eram impecáveis, os motoristas muito profissionais e atenciosos com os alunos. Recomendo sem hesitar!",
      avatar: "/placeholder.svg?height=100&width=100",
    },
    {
      name: "Carlos Oliveira",
      company: "Indústrias Tecnológicas Ltda",
      text: "Utilizamos os serviços da Fabrício Turismo para o transporte diário dos nossos colaboradores há mais de 5 anos. A pontualidade e a qualidade do serviço são impressionantes. Uma parceria de sucesso!",
      avatar: "/placeholder.svg?height=100&width=100",
    },
    {
      name: "Pastor João Paulo",
      company: "Igreja Evangélica Renascer",
      text: "Nossa igreja contratou a Fabrício Turismo para um retiro espiritual com mais de 100 pessoas. O atendimento foi excelente desde o orçamento até o final da viagem. Motoristas educados e veículos muito confortáveis.",
      avatar: "/placeholder.svg?height=100&width=100",
    },
  ]

  return (
    <section id="depoimentos" className="py-16 md:py-24">
      <div className="container">
        <div className="text-center max-w-3xl mx-auto mb-16">
          <div className="inline-block rounded-lg bg-blue-100 px-3 py-1 text-sm text-blue-800">Depoimentos</div>
          <h2 className="mt-3 text-3xl font-bold tracking-tight sm:text-4xl">O que nossos clientes dizem</h2>
          <p className="mt-4 text-gray-600">
            A satisfação dos nossos clientes é o nosso maior orgulho. Confira alguns depoimentos de quem já utilizou
            nossos serviços.
          </p>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
          {testimonials.map((testimonial, index) => (
            <div key={index} className="bg-white p-6 rounded-lg shadow-md border border-gray-100">
              <div className="flex items-center gap-4 mb-4">
                <Image
                  src={testimonial.avatar || "/placeholder.svg"}
                  alt={testimonial.name}
                  width={50}
                  height={50}
                  className="rounded-full"
                />
                <div>
                  <h3 className="font-semibold">{testimonial.name}</h3>
                  <p className="text-sm text-gray-600">{testimonial.company}</p>
                </div>
              </div>
              <p className="text-gray-600 italic">"{testimonial.text}"</p>
            </div>
          ))}
        </div>
      </div>
    </section>
  )
}

function ContactSection() {
  return (
    <section id="contato" className="py-16 md:py-24 bg-gray-50">
      <div className="container">
        <div className="text-center max-w-3xl mx-auto mb-16">
          <div className="inline-block rounded-lg bg-blue-100 px-3 py-1 text-sm text-blue-800">Contato</div>
          <h2 className="mt-3 text-3xl font-bold tracking-tight sm:text-4xl">Entre em contato conosco</h2>
          <p className="mt-4 text-gray-600">
            Estamos prontos para atender às suas necessidades de transporte. Preencha o formulário abaixo ou utilize um
            dos nossos canais de contato.
          </p>
        </div>

        <div className="grid grid-cols-1 lg:grid-cols-2 gap-12">
          <div className="bg-white p-8 rounded-lg shadow-md">
            <h3 className="text-xl font-semibold mb-6">Solicite um orçamento</h3>
            <ClientContactForm />
          </div>
          <div className="space-y-8">
            <div>
              <h3 className="text-xl font-semibold mb-6">Informações de contato</h3>
              <div className="space-y-4">
                <div className="flex items-start gap-4">
                  <Phone className="h-5 w-5 text-blue-600 mt-0.5" />
                  <div>
                    <h4 className="font-medium">WhatsApp para atendimentos</h4>
                    <p className="text-gray-600">(33) 98422-4260</p>
                  </div>
                </div>
                <div className="flex items-start gap-4">
                  <Mail className="h-5 w-5 text-blue-600 mt-0.5" />
                  <div>
                    <h4 className="font-medium">E-mail</h4>
                    <p className="text-gray-600">contato@fabricioturismo.com.br</p>
                  </div>
                </div>
                <div className="flex items-start gap-4">
                  <MapPin className="h-5 w-5 text-blue-600 mt-0.5" />
                  <div>
                    <h4 className="font-medium">Onde estamos?</h4>
                    <p className="text-gray-600">Rua Mentroz Magalhães, 35, Nova Cidade, Ipanema - MG</p>
                    <a
                      href="https://maps.google.com/?q=Rua+Mentroz+Magalhães,+35,+Nova+Cidade,+Ipanema,+MG"
                      target="_blank"
                      rel="noopener noreferrer"
                      className="inline-block mt-1 text-blue-600 hover:underline font-medium"
                    >
                      VER NO MAPA
                    </a>
                  </div>
                </div>
              </div>
            </div>
            <div>
              <h3 className="text-xl font-semibold mb-6">Horário de atendimento</h3>
              <p className="text-gray-600">
                Segunda a Sexta: 8h às 18h
                <br />
                Sábado: 9h às 13h
              </p>
            </div>
            <div>
              <h3 className="text-xl font-semibold mb-4">Siga-nos nas redes sociais</h3>
              <div className="flex gap-4">
                <Link
                  href="https://instagram.com/fabricio.turismo"
                  target="_blank"
                  rel="noopener noreferrer"
                  className="h-10 w-10 flex items-center justify-center rounded-full bg-blue-600 text-white hover:bg-blue-700 transition-colors"
                >
                  <Instagram className="h-5 w-5" />
                  <span className="sr-only">Instagram</span>
                </Link>
                <div className="flex items-center">
                  <span className="ml-2 text-gray-600">@fabricio.turismo</span>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  )
}

function Footer() {
  return (
    <footer className="bg-gray-900 text-gray-300 py-12">
      <div className="container">
        <div className="grid grid-cols-1 md:grid-cols-4 gap-8">
          <div className="space-y-4">
            <div className="flex items-center gap-2">
              <Bus className="h-6 w-6 text-blue-400" />
              <span className="text-xl font-bold text-white">Fabrício Turismo</span>
            </div>
            <p>
              Soluções de transporte com conforto, segurança e pontualidade para empresas, escolas, igrejas e eventos.
            </p>
          </div>
          <div>
            <h3 className="text-lg font-semibold text-white mb-4">Links Rápidos</h3>
            <ul className="space-y-2">
              <li>
                <a href="#home" className="hover:text-blue-400 transition-colors">
                  Início
                </a>
              </li>
              <li>
                <a href="#sobre" className="hover:text-blue-400 transition-colors">
                  Sobre Nós
                </a>
              </li>
              <li>
                <a href="#servicos" className="hover:text-blue-400 transition-colors">
                  Serviços
                </a>
              </li>
              <li>
                <a href="#frota" className="hover:text-blue-400 transition-colors">
                  Nossa Frota
                </a>
              </li>
              <li>
                <a href="#depoimentos" className="hover:text-blue-400 transition-colors">
                  Depoimentos
                </a>
              </li>
              <li>
                <a href="#contato" className="hover:text-blue-400 transition-colors">
                  Contato
                </a>
              </li>
            </ul>
          </div>
          <div>
            <h3 className="text-lg font-semibold text-white mb-4">Serviços</h3>
            <ul className="space-y-2">
              <li>
                <a href="#" className="hover:text-blue-400 transition-colors">
                  Eventos Corporativos
                </a>
              </li>
              <li>
                <a href="#" className="hover:text-blue-400 transition-colors">
                  Turismo & Excursões
                </a>
              </li>
              <li>
                <a href="#" className="hover:text-blue-400 transition-colors">
                  Eventos Escolares
                </a>
              </li>
              <li>
                <a href="#" className="hover:text-blue-400 transition-colors">
                  Eventos Religiosos
                </a>
              </li>
              <li>
                <a href="#" className="hover:text-blue-400 transition-colors">
                  Transporte de Funcionários
                </a>
              </li>
              <li>
                <a href="#" className="hover:text-blue-400 transition-colors">
                  Eventos Esportivos
                </a>
              </li>
            </ul>
          </div>
          <div>
            <h3 className="text-lg font-semibold text-white mb-4">Contato</h3>
            <ul className="space-y-2">
              <li className="flex items-center gap-2">
                <Phone className="h-4 w-4 text-blue-400" />
                <span>(33) 98422-4260</span>
              </li>
              <li className="flex items-center gap-2">
                <Mail className="h-4 w-4 text-blue-400" />
                <span>contato@fabricioturismo.com.br</span>
              </li>
              <li className="flex items-center gap-2">
                <MapPin className="h-4 w-4 text-blue-400" />
                <span>Rua Mentroz Magalhães, 35, Nova Cidade, Ipanema - MG</span>
              </li>
            </ul>
            <div className="flex gap-4 mt-4">
              <Link
                href="https://instagram.com/fabricio.turismo"
                target="_blank"
                rel="noopener noreferrer"
                className="text-gray-300 hover:text-blue-400 transition-colors"
              >
                <Instagram className="h-5 w-5" />
                <span className="sr-only">Instagram</span>
              </Link>
            </div>
          </div>
        </div>
        <div className="border-t border-gray-800 mt-8 pt-8 text-center text-sm">
          <p>&copy; {new Date().getFullYear()} Fabrício Turismo. Todos os direitos reservados.</p>
        </div>
      </div>
    </footer>
  )
}

